*! version 5.0
* 13 August 2018
* NIDS 
* Merging the birth history section to the individual datasets.
	* Reshape needed because birth history is in wide format in the mother's questionnaire.
	* Data must be in long format.

*=====================================================================================================================================

* This do-file will run on all waves

* GLOBALS FOR DATA FILES AND VERSION SUFFIXES

global DataIN "C:\Users\Admin\Desktop\Data"
global DataOUT "C:\Users\Admin\Desktop\Data"
global VersionIN "W5_Anon_V1.0.0"
global VersionOUT "merged"

							
version 15.1													// version of Stata being used, this is needed for the rename command.

*=====================================================================================================================================

* OPENING THE ADULT DTA & KEEPING ONLY BIRTH HISTORY VARIABLES

set more off

use "$DataIN\Adult_$VersionIN.dta", clear												// opening the dataset

rename w#_a_* *
rename w#_hhid hhid
keep hhid pid bh*		// keeping only birth history variables
drop bhlive bhlive_n bhali bhali_n bhbrth - bhprg

reshape long bhgen bhdob_m bhdob_y bhali bhdth bhdthun bhdod_m ///
bhdod_y bhlive  bhmem bhres bhchild_id, i(pid hhid) j(child_num) string  				// reshaping data from wide to long format
destring  child_num, replace force														// converting string to numeric

* labeling variables

label var	child_num	"Number of child in BH Roster"
label var	bhgen		"c2_2 - Gender of child"
label var	bhdob_m		"c2_3_m - Date of birth (month) of child"
label var	bhdob_y		"c2_3_y - Date of birth (year) of child"
label var	bhali		"c2_4 - Child still alive"
label var	bhdod_m		"c2_5_m - Date of death (month) of child"
label var	bhdod_y		"c2_5_y - Date of death (year) of child"
cap label var	bhlive		"c2_6 - Child is still resident in household"
cap label var	bhres		"c2_11 - Child is still resident in household"
cap label var	bhmem		"c2_10 - Child is still member in household"
label var	bhchild_id	"c2_7_id - Child pid"
cap label var	bhdth		"c2_5 - Age at death of child"
cap label var	bhdthun		"c2_6 - Days/Months/ Years at death of child"

foreach x of varlist bhlive bhmem bhres bhdth bhdthun bhdob_m bhdod_y bhdod_m {			// dropping empty variables
quietly sum `x'
	if r(N) == 0 {
	drop `x'
	}
}

drop if  bhchild_id==.											// dropping observations that do not have any data
drop if  bhchild_id== -8
drop if  bhchild_id== -3
duplicates drop bhchild_id, force

save "$temp\bh_reshaped.dta", replace							// saving the reshaped birth history data as a temp file												

*--------------------------------------------------------------------------------------------------------------------------------------

* OPENING THE CHILD, PROXY AND ADULT, APPENDING THEM AND PREPARING THEM FOR MERGE INTO BIRTH HISTORY
* Temporary files generated will be erased on completion of this .do file.

* ADULT

use "$DataIN\Adult_$VersionIN.dta", clear					// opening the dataset

rename w#_a* w#*											// replacing the current prefix with a wave specific prefix
gen dataset = "Adult"										// generating a variable to indicate the source dataset
	
save "$temp\adult.dta", replace								// saving the modified data as a temp file

* PROXY

use "$DataIN\Proxy_$VersionIN.dta", clear					// opening the dataset

rename w#_p* w#*											// replacing the current prefix with a wave specific prefix
gen dataset = "Proxy"										// generating a variable to indicate the source dataset

save "$temp\proxy.dta", replace								// saving the modified data as a temp file

* CHILD

use "$DataIN\Child_$VersionIN.dta", clear					// opening the dataset

rename w#_c* w#*											// replacing the current prefix with a wave specific prefix
gen dataset = "Child"										// generating a variable to indicate the source dataset

append using "$temp\adult.dta", force								// appending the modified adult temp file to the modified child file
append using "$temp\proxy.dta", force								// appending the modified proxy temp file to the modified adult and child file

rename pid 	bhchild_id
rename w#_hhid w#_hhid_child

order dataset, last											// moving the variable "dataset" to the end of the dataset

save "$temp\children.dta", replace							// saving the adjusted data in temp file

*--------------------------------------------------------------------------------------------------------------------------------------------------
* RESTORING RESHAPED BIRTH HISTORY AND MERGING IN THE CREATED INDIVIDUAL DATASET.

use "$temp\bh_reshaped.dta", clear							// opening the reshaped birth history data

merge 1:1 bhchild_id using "$temp\children.dta"				// merging in individual records into birth history

drop if _merge != 3											// dropping individuals that do not merge into the birth history.
drop _merge

save "$DataOUT\Birth_History_with_indi_$VersionOUT.dta", replace			// saving the birth history roster, including individual child q's

*-------------------------------------------------------------------------------------------------------------------------------------------

* ERASING THE TEMP FILES

erase "$temp\adult.dta"
erase "$temp\proxy.dta"
erase "$temp\children.dta"
erase "$temp\bh_reshaped.dta"

* end of do file 

*====================================================================================================================================================
